#include <bits/stdc++.h>

#define int int64_t

const int N = 5e6;

int nodes = 2;

int w = 1e12;

std::vector<int> ll(N), rr(N);

struct Node {
  int sum = 0, cnt = 0;
};

Node operator + (Node a, Node b){
  Node c;
  c.sum = a.sum + b.sum;
  c.cnt = a.cnt + b.cnt;
  return c;
}

Node t[N];

Node query(int v, int tl, int tr, int l, int r) {
  if(tl >= l && tr <= r) {
    return t[v];
  }
  int mid = (tl + tr) / 2;
  if(!ll[v]) {
    ll[v] = nodes++;
  }
  if(!rr[v]) {
    rr[v] = nodes++;
  }
  if(r <= mid) {
    return query(ll[v], tl, mid, l, r);
  }
  else if(l > mid) {
    return query(rr[v], mid + 1, tr, l, r);
  }
  else {
    return query(ll[v], tl, mid, l, r) + query(rr[v], mid + 1, tr, l, r);
  }
}

void add(int v, int tl, int tr, int index, int value) {
  if(tl == tr) {
    t[v].sum += value;
    t[v].cnt += 1;
    return;
  }
  int mid = (tl + tr) / 2;
  if(!ll[v]) {
    ll[v] = nodes++;
  }
  if(!rr[v]) {
    rr[v] = nodes++;
  }
  if(index <= mid) {
    add(ll[v], tl, mid, index, value);
  }
  else {
    add(rr[v], mid + 1, tr, index, value);
  }
  t[v] = t[ll[v]] + t[rr[v]];
}

void del(int v, int tl, int tr, int index, int value) {
  if(tl == tr) {
    t[v].sum -= value;
    t[v].cnt -= 1;
    return;
  }
  int mid = (tl + tr) / 2;
  if(!ll[v]) {
    ll[v] = nodes++;
  }
  if(!rr[v]) {
    rr[v] = nodes++;
  }
  if(index <= mid) {
    del(ll[v], tl, mid, index, value);
  }
  else {
    del(rr[v], mid + 1, tr, index, value);
  }
  t[v] = t[ll[v]] + t[rr[v]];
}


signed main() {
  int n, q;
  std::cin >> n >> q;
  std::vector<int> a(n + 1);
  int sum = 0;
  for(int i = 1; i <= n; i++) {
    std::cin >> a[i];
    sum += a[i];
  }
  std::set<int> st[n + 1];
  for(int i = 1; i <= n; i++) {
    st[a[i]].insert(i);
  }
  std::vector<int> cnt(n + 1);
  for(int i = 1; i <= n; i++) {
    cnt[a[i]] += 1;
  }
  for(int i = 1; i <= n; i++) {
    if(st[i].size()) {
      add(1, 1, w, cnt[i] * i, cnt[i] * i);
    }
  }
  while(q--) {
    int t;
    std::cin >> t;
    if(t == 1) {
      int k;
      std::cin >> k;
      int ans = sum;
      int m = n - k;
      if(!m) {
        std::cout << ans << "\n";
        continue;
      }
      int l = 1, r = w, pos = - 1;
      while(l <= r) {
        int mid = (l + r) / 2;
        if(query(1, 1, w, mid, w).cnt >= m) {
          pos = mid;
          l = mid + 1;
        }
        else {
          r = mid - 1;
        }
      }
      if(pos == - 1) {
        std::cout << 0 << "\n";
        continue;
      }
      ans -= query(1, 1, w, pos + 1, w).sum;
      m -= query(1, 1, w, pos + 1, w).cnt;
      ans -= m * pos;
      std::cout << ans << "\n";
    }
    else {
      int x, y;
      std::cin >> x >> y;
      if(*--st[a[x]].end() == x) {
        del(1, 1, w, cnt[a[x]] * a[x], cnt[a[x]] * a[x]);
        if(cnt[a[x]] > 1) {
          add(1, 1, w, (cnt[a[x]] - 1) * a[x], (cnt[a[x]] - 1) * a[x]);
        }
      }
      cnt[a[x]] -= 1;
      st[a[x]].erase(x);
      sum -= a[x];
      a[x] = y;
      st[a[x]].insert(x);
      if(*--st[a[x]].end() == x) {
        del(1, 1, w, cnt[a[x]] * a[x], cnt[a[x]] * a[x]);
        add(1, 1, w, (cnt[a[x]] + 1) * a[x], (cnt[a[x]] + 1) * a[x]);
      }
      cnt[a[x]] += 1;
      sum += a[x];
    }
  }
}